/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validators.CoffeeValidator.java
 * Desprition : This Validators class is responsible for checking and validating the 
 * Customer Coffee preference Information
 * 
 */
package Validators;

import JavaBeans.*;
/**
 * @author student
 *
 * This class is being used for validating a given coffee data.
 * 
 */
public class CoffeeValidator {

	private String message;

	
	/**
	 * This method is being used for getting an error message if the 
	 * validation was unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * This method is being used for setting an error message if the validation
	 * is unsuccessful.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used for validation of a given coffee data.
	 * @param coffeeData The coffee details to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(Coffee_Data coffeeData) {

		Coffee_Data coffeedata = coffeeData;
		String type, size;
		String quantity;
		String itemcode;
		String description;

		itemcode = coffeedata.getItemCode();
		type = coffeedata.getType();
		size = coffeedata.getSize();
		description = coffeedata.getDescription();

		System.out.println("coffee description : " + description);
		System.out.println("coffee type : " + type);
		System.out.println("coffee size : " + size);
		System.out.println("coffee itemCode : " + itemcode);
		
		//check coffee type.
		if (type == null) {
			message = "Coffee type is null.";
			return false;
		}
		if (!type.matches("^[a-zA-Z/s/-/$/0-9/ ]+$")) {
			return false;
		}
					
		return true;

	}

}
